import java.util.concurrent.locks.*;

class MyCounter
{
  private int counter;
  private ReentrantLock counterLock = new ReentrantLock();
  private Condition nonNegCond  = counterLock.newCondition();
  public MyCounter(int counterVal)
  {
    counter = counterVal;
  }
  public void add(int val) throws InterruptedException
  {
    counterLock.lock();
    try{
      while(counter + val < 0){
        nonNegCond.await();
      }
      counter += val;
      nonNegCond.signalAll();
    }
    finally{
      counterLock.unlock();
    }
  }
  public int getCounter()
  {
    return counter;
  }
}